/*	Copyright (c) 1993  Cogent Data Technologies, Inc. */
/*	All Rights Reserved */


static char prog_copyright[] = "Copyright 1993 Cogent Data Technologies";

#ident	"@(#)kit:src/em932.cf/Space.c	1.00"
#ident  "$Header: $"

#include <sys/types.h>
#include <sys/stream.h>
#include <sys/dlpi_ether.h>
#include <config.h>

/*
 *  The N_SAPS define determines how many protocol drivers can bind to a single
 *  E/M III board.  A TCP/IP environment requires a minimum of two (IP and ARP).
 *  Putting an excessively large value here would waste memory.  A value that
 *  is too small could prevent a system from supporting a desired protocol.
 */
#define	N_SAPS		8

#define	STREAMS_LOG	0

/*
 *  The IFNAME define determines the name of the the internet statistics
 *  structure for this driver and only has meaning if the inet package is
 *  installed.  It should match the interface prefix specified in the strcf(4)
 *  file and ifconfig(1M) command used in rc.inet.  The unit number of the
 *  interface will match the board number (i.e emD0, emD1, emD2) and is not
 *  defined here.
 */
#define	IFNAME	"emD"

/********************** STOP!  DON'T TOUCH THAT DIAL ************************
 *
 *  The following values are set by the kernel build utilities and should not
 *  be modified by mere motals.
 */
int		emDboards = EMD_CNTLS;
int		emDstrlog = STREAMS_LOG;
char		*emD_ifname = IFNAME;
DL_sap_t	emDsaps[ N_SAPS * EMD_CNTLS ];
DL_bdconfig_t	emDconfig[ EMD_CNTLS ] = {
#ifdef EMD_0
	{
		EMD_CMAJOR_0,		/* Major number			*/
		EMD_0_SIOA,		/* Start of base I/O address	*/
		EMD_0_EIOA,		/* End of base I/O address	*/
		EMD_0_SCMA,		/* Start of base memory address	*/
		EMD_0_ECMA,		/* End of base memory address	*/
		EMD_0_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMD_1
	{
		EMD_CMAJOR_1,		/* Major number			*/
		EMD_1_SIOA,		/* Start of base I/O address	*/
		EMD_1_EIOA,		/* End of base I/O address	*/
		EMD_1_SCMA,		/* Start of base memory address	*/
		EMD_1_ECMA,		/* End of base memory address	*/
		EMD_1_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMD_2
	{
		EMD_CMAJOR_2,		/* Major number			*/
		EMD_2_SIOA,		/* Start of base I/O address	*/
		EMD_2_EIOA,		/* End of base I/O address	*/
		EMD_2_SCMA,		/* Start of base memory address	*/
		EMD_2_ECMA,		/* End of base memory address	*/
		EMD_2_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMD_3
	{
		EMD_CMAJOR_3,		/* Major number			*/
		EMD_3_SIOA,		/* Start of base I/O address	*/
		EMD_3_EIOA,		/* End of base I/O address	*/
		EMD_3_SCMA,		/* Start of base memory address	*/
		EMD_3_ECMA,		/* End of base memory address	*/
		EMD_3_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMD_4
	{
		EMD_CMAJOR_4,		/* Major number			*/
		EMD_4_SIOA,		/* Start of base I/O address	*/
		EMD_4_EIOA,		/* End of base I/O address	*/
		EMD_4_SCMA,		/* Start of base memory address	*/
		EMD_4_ECMA,		/* End of base memory address	*/
		EMD_4_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMD_5
	{
		EMD_CMAJOR_5,		/* Major number			*/
		EMD_5_SIOA,		/* Start of base I/O address	*/
		EMD_5_EIOA,		/* End of base I/O address	*/
		EMD_5_SCMA,		/* Start of base memory address	*/
		EMD_5_ECMA,		/* End of base memory address	*/
		EMD_5_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMD_6
	{
		EMD_CMAJOR_6,		/* Major number			*/
		EMD_6_SIOA,		/* Start of base I/O address	*/
		EMD_6_EIOA,		/* End of base I/O address	*/
		EMD_6_SCMA,		/* Start of base memory address	*/
		EMD_6_ECMA,		/* End of base memory address	*/
		EMD_6_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMD_7
	{
		EMD_CMAJOR_7,		/* Major number			*/
		EMD_7_SIOA,		/* Start of base I/O address	*/
		EMD_7_EIOA,		/* End of base I/O address	*/
		EMD_7_SCMA,		/* Start of base memory address	*/
		EMD_7_ECMA,		/* End of base memory address	*/
		EMD_7_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
};

#ifdef IP
int	emDinetstats = 1;
#else
int	emDinetstats = 0;
#endif

int	emDbus_t_on = 30;
