#ifndef _IO_DLPI_ETHER_DLPI_EMD_H	/* wrapper symbol for kernel use */
#define _IO_DLPI_ETHER_DLPI_EMD_H	/* subject to change without notice */

#ident	"@(#)kit:eth/src/dlpi_932.h	1.00"
#ident  "$Header: $"

/*	Copyright (c) 1993  Cogent Data Technologies			*/
/*	All Rights Reserved						*/
/*									*/
/*									*/
/*      eMASTER+ ATS DLPI streams device driver				*/
/*									*/
/*      Initiate version:       1.0             			*/
/*      Date:                   Sept. 24, 1993   			*/
/*                                                                      */
/* -------------------------------------------------------------------- */
/*                                                                      */
/*      Modification log:                                               */
/*                                                                      */
/* -------------------------------------------------------------------- */

/*
 *  Device dependent symbol names.
 */

/*
 *  STREAMS structures
 */
#define	DL_NAME		"emD"
#define	DLdevflag	emDdevflag
#define	DLrminfo	emDrminfo
#define	DLwminfo	emDwminfo
#define	DLrinit		emDrinit
#define	DLwinit		emDwinit

/*
 *  Functions
 */
#define DLopen		emDopen
#define	DLclose		emDclose
#define DLrput		emDrput
#define	DLwput		emDwput
#define	DLioctl		emDioctl
#define	DLinfo		emDinfo
#define	DLloopback	emDloopback
#define	DLmk_ud_ind	emDmk_ud_ind
#define	DLxmit_packet	emDxmit_packet
#define	DLintr		emDintr
#define	DLinfo_req	emDinfo_req
#define	DLcmds		emDcmds
#define	DLprint_eaddr	emDprint_eaddr
#define	DLbind_req	emDbind_req
#define	DLrsrv		emDrsrv
#define	DLunbind_req	emDunbind_req
#define	DLunitdata_req	emDunitdata_req
#define	DLerror_ack	emDerror_ack
#define	DLuderror_ind	emDuderror_ind
#define	DLpromisc_off	emDpromisc_off
#define	DLpromisc_on	emDpromisc_on
#define	DLset_eaddr	emDset_eaddr
#define	DLadd_multicast	emDadd_multicast
#define	DLset_multicast	emDset_multicast
#define	DLdel_multicast	emDdel_multicast
#define	DLdisable	emDdisable
#define	DLenable	emDenable
#define	DLreset		emDreset
#define	DLis_multicast	emDis_multicast
#define	DLget_multicast	emDget_multicast
#define DLrecv		emDrecv
#define DLproc_llc	emDproc_llc
#define DLform_80223	emDform_80223
#define DLmk_test_con	emDmk_test_con
#define DLinsert_sap	emDinsert_sap
#define DLsubsbind_req	emDsubsbind_req
#define DLtest_req	emDtest_req
#define DLremove_sap	emDremove_sap
#define DLis_equalsnap	emDis_equalsnap
#define DLform_snap	emDform_snap
#define DLis_broadcast	emDis_broadcast
#define DLis_us		emDis_us
#define DLis_validsnap	emDis_validsnap

#define DLbdspecioctl	emDbdspecioctl
#define DLbdspecclose	emDbdspecclose

/*
 *  wrapper functions
 */
#define DLinit		emDinit
#define DLuninit	emDuninit
#define DL_attach_info	emD_attach_info
/*
 *  Implementation structures and variables
 */
#define DL_ifname	emD_ifname
#define DLprint_eaddr	emDprint_eaddr
#define DLboards	emDboards
#define DLconfig	emDconfig
#define DLsaps		emDsaps
#define DLstrlog	emDstrlog
#define DLifstats	emDifstats
#define	DLinetstats	emDinetstats
#define	DLid_string	emDid_string
#define	DLcopyright	emDcopyright
#define	DLbus_t_on	emDbus_t_on
#define	em_debug	emDdebug

/*
 *  Flow control defines
 */
#define DL_MIN_PACKET		0
#define DL_MAX_PACKET		1500
#define DL_MAX_PACKET_LLC	(DL_MAX_PACKET - 3)
#define DL_MAX_PACKET_SNAP	(DL_MAX_PACKET_LLC - 5)
#define	DL_HIWATER		(40 * DL_MAX_PACKET)
#define	DL_LOWATER		(20 * DL_MAX_PACKET)

#define	USER_MAX_SIZE		1500
#define	USER_MIN_SIZE		46

/* Inline asm routine for block moves */
#ifndef lint
#ifndef C_PIO

asm	void mybcopy(src, dest, count)
{
%mem	src, dest, count;lab	r_1;
	movl	count, %ecx
	movl	dest, %eax
	push	%edi
	push	%esi
	movl	%eax, %edi	/* %edi = destination */
	movl	src, %eax  	
	movl	%eax, %esi	/* %esi = source */
	testw	$1, %cx		/* bit 0 set? */
	jz	r_1
	movsb
	dec	%ecx
r_1:
	shrl	$1, %ecx	/* cx <- cx / 2 */
	rep		
	movsw
	pop	%esi
	pop	%edi
}

#endif	/* ifndef C_PIO */
#endif	/* ifndef lint */

#endif	/* _IO_DLPI_ETHER_DLPI_EMD_H */
