#ifndef _IO_DLPI_ETHER_DLPI_EMA_H	/* wrapper symbol for kernel use */
#define _IO_DLPI_ETHER_DLPI_EMA_H	/* subject to change without notice */

#ident	"@(#)kit:eth/src/dlpi_845.h	1.00"
#ident  "$Header: $"

/*	Copyright (c) 1993  Cogent Data Technologies			*/
/*	All Rights Reserved						*/
/*									*/
/*									*/
/*      eMASTER+ ATS DLPI streams device driver				*/
/*									*/
/*      Initiate version:       1.0             			*/
/*      Date:                   Sept. 24, 1993   			*/
/*                                                                      */
/* -------------------------------------------------------------------- */
/*                                                                      */
/*      Modification log:                                               */
/*                                                                      */
/* -------------------------------------------------------------------- */

/*
 *  Device dependent symbol names.
 */

/*
 *  STREAMS structures
 */
#define	DL_NAME		"emA"
#define	DLdevflag	emAdevflag
#define	DLrminfo	emArminfo
#define	DLwminfo	emAwminfo
#define	DLrinit		emArinit
#define	DLwinit		emAwinit

/*
 *  Functions
 */
#define DLopen		emAopen
#define	DLclose		emAclose
#define DLrput		emArput
#define	DLwput		emAwput
#define	DLioctl		emAioctl
#define	DLinfo		emAinfo
#define	DLloopback	emAloopback
#define	DLmk_ud_ind	emAmk_ud_ind
#define	DLxmit_packet	emAxmit_packet
#define	DLintr		emAintr
#define	DLinfo_req	emAinfo_req
#define	DLcmds		emAcmds
#define	DLprint_eaddr	emAprint_eaddr
#define	DLbind_req	emAbind_req
#define	DLrsrv		emArsrv
#define	DLunbind_req	emAunbind_req
#define	DLunitdata_req	emAunitdata_req
#define	DLerror_ack	emAerror_ack
#define	DLuderror_ind	emAuderror_ind
#define	DLpromisc_off	emApromisc_off
#define	DLpromisc_on	emApromisc_on
#define	DLset_eaddr	emAset_eaddr
#define	DLadd_multicast	emAadd_multicast
#define	DLset_multicast	emAset_multicast
#define	DLdel_multicast	emAdel_multicast
#define	DLdisable	emAdisable
#define	DLenable	emAenable
#define	DLreset		emAreset
#define	DLis_multicast	emAis_multicast
#define	DLget_multicast	emAget_multicast
#define DLrecv		emArecv
#define DLproc_llc	emAproc_llc
#define DLform_80223	emAform_80223
#define DLmk_test_con	emAmk_test_con
#define DLinsert_sap	emAinsert_sap
#define DLsubsbind_req	emAsubsbind_req
#define DLtest_req	emAtest_req
#define DLremove_sap	emAremove_sap
#define DLis_equalsnap	emAis_equalsnap
#define DLform_snap	emAform_snap
#define DLis_broadcast	emAis_broadcast
#define DLis_us		emAis_us
#define DLis_validsnap	emAis_validsnap

#define DLbdspecioctl	emAbdspecioctl
#define DLbdspecclose	emAbdspecclose

/*
 *  wrapper functions
 */
#define DLinit		emAinit
#define DLuninit	emAuninit
#define DL_attach_info	emA_attach_info
/*
 *  Implementation structures and variables
 */
#define DL_ifname	emA_ifname
#define DLprint_eaddr	emAprint_eaddr
#define DLboards	emAboards
#define DLconfig	emAconfig
#define DLsaps		emAsaps
#define DLstrlog	emAstrlog
#define DLifstats	emAifstats
#define	DLinetstats	emAinetstats
#define	DLid_string	emAid_string
#define	DLcopyright	emAcopyright
#define	DLbus_t_on	emAbus_t_on
#define	em_debug	emAdebug

/*
 *  Flow control defines
 */
#define DL_MIN_PACKET		0
#define DL_MAX_PACKET		1500
#define DL_MAX_PACKET_LLC	(DL_MAX_PACKET - 3)
#define DL_MAX_PACKET_SNAP	(DL_MAX_PACKET_LLC - 5)
#define	DL_HIWATER		(40 * DL_MAX_PACKET)
#define	DL_LOWATER		(20 * DL_MAX_PACKET)

#define	USER_MAX_SIZE		1500
#define	USER_MIN_SIZE		46

/* Inline asm routine for block moves */
#ifndef lint
#ifndef C_PIO

asm	void mybcopy(src, dest, count)
{
%mem	src, dest, count;lab	r_1;
	movl	count, %ecx
	movl	dest, %eax
	push	%edi
	push	%esi
	movl	%eax, %edi	/* %edi = destination */
	movl	src, %eax  	
	movl	%eax, %esi	/* %esi = source */
	testw	$1, %cx		/* bit 0 set? */
	jz	r_1
	movsb
	dec	%ecx
r_1:
	shrl	$1, %ecx	/* cx <- cx / 2 */
	rep		
	movsw
	pop	%esi
	pop	%edi
}

#endif	/* ifndef C_PIO */
#endif	/* ifndef lint */

#endif	/* _IO_DLPI_ETHER_DLPI_EMA_H */
