/*
 * VGA Constants
 */

#define	HSIZE	320		/* Length of a scanline in pixels */

/*
 * Memory addresses
 */
#define	VRAM		(unsigned char *)(0xf80a0000)	/* VGA Video RAM */
#define	VRAMSIZE	64000

/*
 * Standard colors
 */
#define	VGA_BLACK	0
#define	VGA_RED		2
#define	VGA_YELLOW	44
#define	VGA_GREEN	86
#define	VGA_CYAN	128
#define	VGA_BLUE	170
#define	VGA_MAGENTA	212
#define	VGA_WHITE	1

/*
 * Raster ops
 */
#define	ROP_STORE	1
#define	ROP_OR		2
#define	ROP_XOR		3
#define	ROP_CLEAR	4
#define	VGA_MINROP	1
#define	VGA_MAXROP	4

struct	vga_color_map	{
	float	c_red;		/* Red value [0.0, 1.0] */
	float	c_green;	/* Green value [0.0, 1.0] */
	float	c_blue;		/* Blue value [0.0, 1.0] */
};

struct	cmap	{
	unsigned char	c_blue;
	unsigned char	c_green;
	unsigned char	c_red;
};

typedef	short			pos_t;
typedef	unsigned char		color_t;
typedef	struct vga_color_map	color_map_t;
