/*
 * vga_rect - draw filled rectangle
 *
 * 11/18/90 - Copyright (c) 1990, Hauppauge Computer Works
 *
 */
#include "vgadefs.h"

static long lmsk[4] = {
	0x00000000, 0xffffff00, 0xffff0000, 0xff000000
};
static long rmsk[4] = {
	0x00000000, 0x000000ff, 0x0000ffff, 0x00ffffff
};

vga_rect(xo, yo, xl, yl)
register pos_t xo, yo, xl, yl;
{
	register int i;
	register color_t cval;
	register long lcval;
	register long *lp, *lp1;
	register long lmask, rmask;
	register unsigned char *s, *p;
	long lval;

	cval = _FB_COLOR;
#ifdef LONGS
	/* See if we should do move in longs */
	if(xl >= 12){
		s = (color_t *)(&lval);
		*s++ = cval;
		*s++ = cval;
		*s++ = cval;
		*s = cval;
		lcval = lval;
		/* Make left, right masks */
		i = xo & 3;
		if((lmask = lmsk[i]) != 0){
			xl -= (4-i);
		}
		i = xl & 3;
		if((rmask = rmsk[i]) != 0){
			xl -= i;
		}
		xl >>= 2;
		lp = (long *)(VRAM) + (yo*HSIZE/4) + (xo>>2);
		while(yl-- > 0){
			lp1 = lp;
			if(lmask){
				*lp1 = (*lp1 & ~lmask) | (lcval & lmask);
				lp1++;
			}
			for(i = xl; i > 0; i--)
				*lp1++ = lcval;
			if(rmask){
				*lp1 = (*lp1 & ~rmask) | (lcval & rmask);
			}
			lp += HSIZE/4;
		}
	} else	{
#else
		p = VRAM + (HSIZE*yo) + xo;
		while(yl-- > 0){
			for(i = 0, s = p; i < xl; i++)
				*s++ = cval;
			p += HSIZE;
		}
#endif
#ifdef LONGS
	}
#endif
}
